//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

#include "6812_REG_bit_V2.h"

void	init_system();
uchar	flag1;
uint	reg1;

//P74 connects to LED. when waking up, this pin is flashing twice
//P44 key low active.  KWI7 pin is a wake-up function pin, wake-up once when it is grounded


delay()
{
		reg1=0;
	
	while(reg1<10000){reg1++;clr_wdt;}

	
}



//===========================================================================================
void main()
{
	flag1=0;
	init_system();
	
	p7cr4=out_mode;

	p4cr4=in_mode;	//set P44 as input pin
	p4pu4=1;		//enable built-in pull-up resistor
	p4pd4=0;		//disable built-in pull-down resistor
	
	kw4en=1;		//enable P44 wake up function
	kw4le=0;		//low active.	
	
	outen=1;		//set the port output to hold state in the STOP mode
	
	
	p74=0;
	delay();
	delay();
	delay();
	delay();
	p74=1;
	delay();
	delay();
	delay();
	delay();
	p74=0;
	delay();
	delay();
	delay();
	delay();
	p74=1;
	delay();
	delay();
	delay();
	delay();
	




while(1)
{
	
	
	flag1^=0xff;
	
	if(flag1==0){p74=0;}
		else{p74=1;}
	
	
	while(p4prd4==0){clr_wdt;}
		delay();
	while(p4prd4==0){clr_wdt;}
		delay();
		
		
		
	stop=1;
	
	
}	
	
	
}





//============================================================================================



void	init_system()
{
	clr_wdt;
	
	P0CR.byte=0xff;
	P1CR.byte=0xff;
	P2CR.byte=0xff;
	P4CR.byte=0xff;
	P7CR.byte=0xff;
	P8CR.byte=0xff;
	P9CR.byte=0xff;
	
	
	
	
}




